/*
	CellCtlPopulator.h
	
	Created By:	cwhite
				Sun 03-May-1998

*/

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>

@interface MCCellControllerPopulator : NSObject
{
    id		viewToPopulate;
    id		templateCtl;
    id		delegateToSet;
	
	id		nonRetainedTVC;
    
    NSArray	*controllerList;

    BOOL	specifiedSize;
    int		specifiedHeight;
    int		specifiedWidth;
    BOOL	resizeCells;
    BOOL	keepAspect;
    BOOL	rowMajorOrder;
    BOOL	overlapOnePixel;
    BOOL	beginAtTop;
    BOOL	populateOnAwake;
}

- (void)setModel:aModel;
- (void)setModelNoUpdate:aModel;
- (void)updateInterfaceFromModel;
- (void)updateModelFromInterface;
- (NSArray *)controllerList;

// populate using binder
- (void)populateViews;

// populate using tableview's objectValueForRow delegate method
- (void)setModel:(id)aMod useTVC:(id)aTVC;

- (void)setNumCellsHigh:(int)aValue;
- (void)setNumCellsWide:(int)aValue;

- (void)setTemplateCtl:aCtl;
- templateCtl;
- (NSView *)viewToPopulate;
- (void)setViewToPopulate:(NSView *)aView;
    
@end
